//
//  NSImage+MCAdditions.h
//  MCApplication
//
//  Created by aj on Sat Oct 20 2001.
//  Copyright (c) 2001 __CompanyName__. All rights reserved.
//

#import <AppKit/AppKit.h>


// Can be ORed together to get a proper vertical/horizontl tiling in the space given!
typedef enum _MCImageTileDirection {
    MCImageTileVertical		= 1,
    MCImageTileHorizontal	= 2,
} MCImageTileDirection;



@interface NSImage (MCAdditions)
// Class imageNamed, if nothing returned, gets the image from the bundle in which anObject came from. if anObject is nil, the main bundle is used
+ (NSImage *)imageNamed:(NSString *)imageName inBundleOfObject:(id)anObject;

+ (NSImage *)imageNamed:(NSString *)imageName inBundleForClass:(Class)aClass;
+ (NSImage *)imageNamed:(NSString *)imageName inBundle:(NSBundle *)aBundle;
+ (NSImage *)imageNamed:(NSString *)imageName inBundleWithIdentifier:(NSString *)anIdentifier;

+ (NSImage *)colorBlobWithColor:(NSColor *)aColor;
+ (NSImage *)flatStyleColorBlobWithColor:(NSColor *)aColor;
+ (NSImage *)aquaStyleColorBlobWithColor:(NSColor *)aColor;

- (void)drawFlippedInRect:(NSRect)rect operation:(NSCompositingOperation)op fraction:(float)delta;
- (void)drawFlippedInRect:(NSRect)rect operation:(NSCompositingOperation)op;

// Temporarily resizes the images to fit in the rect - note: your image should have setScalesWhenResized set to YES
- (void)compositeInRect:(NSRect)aRect operation:(NSCompositingOperation)op;
- (void)dissolveInRect: (NSRect)aRect fraction: (float)fraction;

- (NSImage *) tintedImageWithColor:(NSColor *) tint;
- (NSImage *) tintedImageWithColor:(NSColor *) tint operation:(NSCompositingOperation) op;

- (NSString *)imageURLString; // if it can find the path in the registry, it will return a URL string to that path on the user's hard drive

- (void)drawAtPoint:(NSPoint)aPoint;
- (void)drawInRect:(NSRect)aRect;

// This method is not complete.....  did not need it in the end but left the beginnings of it for later! mclark
- (void)tileInRect: (NSRect)aRect direction: (MCImageTileDirection)direction;

- (NSImage*)imageByScalingProportionallyToSize:(NSSize)targetSize;

@end

@interface NSImage (Base64Encoding)
extern NSString *kXML_Base64ReferenceAttribute;

+ (NSImage *)imageWithBase64EncodedString:(NSString *)inBase64String;
- (id)initWithBase64EncodedString:(NSString *)inBase64String;
- (NSString *)base64EncodingWithFileType:(NSBitmapImageFileType)inFileType;

- (NSString *)embeddedHTMLBitmapRepresentation;
@end

